(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5415,        175]*)
(*NotebookOutlinePosition[      6057,        197]*)
(*  CellTagsIndexPosition[      6013,        193]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    StyleBox[\(Pr\[AAcute]cticas\ de\ ordenador\  - \ 
        C\[AAcute]lculo\ 1  \.ba\ de\ Matem\[AAcute]ticas\),
      FontFamily->"Times New Roman",
      FontSize->18], "\[IndentingNewLine]", 
    StyleBox[\(Convergencia\ de\ sucesiones\ y\ series\ de\ funciones\),
      FontFamily->"Times New Roman",
      FontSize->24]}], "Input"],

Cell[BoxData[
    StyleBox[\(Ejemplo\ 1\),
      FontFamily->"Times New Roman",
      FontSize->18]], "Input"],

Cell[BoxData[
    \(\(Plot[Evaluate[Table[x^{i} \((1 - x^{i})\), {i, 15}]], {x, 0, 1}, 
        PlotRange \[Rule] {0, 0.3}];\)\)], "Input"],

Cell[BoxData[
    \(f[n_, x_] := x^n \((1 - x^n)\)\)], "Input"],

Cell[BoxData[
    \(sucesion[n_, x_] := Table[f[i, x], {i, n}]\)], "Input"],

Cell[BoxData[
    \(sucesion[1000, 0.99]\)], "Input"],

Cell[BoxData[
    \(sucesion[1000, 0.999]\)], "Input"],

Cell[BoxData[
    \(m = Floor[Log[10^\(-4\)]/Log[0.999]] + 1\)], "Input"],

Cell[BoxData[
    \(Simplify[D[f[n, x], x]]\)], "Input"],

Cell[BoxData[
    \(\(Table[
        Plot[f[k, x], {x, 0, 1}, PlotRange \[Rule] {0, 0.3}], {k, 
          15}];\)\)], "Input"],

Cell[BoxData[
    StyleBox[\(Ejemplo\ 2\),
      FontFamily->"Times New Roman",
      FontSize->18]], "Input"],

Cell[BoxData[
    \(g[n_, x_] := n \((x^\((1/n)\) - 1)\)\)], "Input"],

Cell[BoxData[{
    \(\(grafgk[n_, a_, b_, c_, d_] := 
        Plot[Evaluate[Table[g[k, x], {k, n}]], {x, a, b}, 
          PlotRange \[Rule] {c, d}, 
          PlotStyle \[Rule] Table[RGBColor[0, 0, 1], {n}], 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(graflog[a_, b_, c_, d_] := 
      Plot[Log[x], {x, a, b}, PlotRange \[Rule] {c, d}, 
        PlotStyle \[Rule] RGBColor[1, 0, 0], 
        DisplayFunction \[Rule] Identity]\)}], "Input"],

Cell[BoxData[
    \(\(graficas[n_, a_, b_, c_, d_] := 
        Show[grafgk[n, a, b, c, d], graflog[a, b, c, d], 
          DisplayFunction \[Rule] $DisplayFunction];\)\)], "Input"],

Cell[BoxData[
    \(\(grafgklog[n_, a_, b_, c_, d_] := 
        Plot[{g[n, x], Log[x]}, {x, a, b}, PlotRange \[Rule] {c, d}, 
          PlotStyle \[Rule] {RGBColor[0, 0, 1], 
              RGBColor[1, 0, 0]}];\)\)], "Input"],

Cell[BoxData[
    \(\(animacion[n_, a_, b_, c_, d_] := 
        Table[grafgklog[k, a, b, c, d], {k, n}];\)\)], "Input"],

Cell[BoxData[
    \(\(graficas[10, 0.3, 15, \(-1\), 5.5];\)\)], "Input"],

Cell[BoxData[
    \(\(animacion[15, 0.3, 15, \(-1\), 5.5];\)\)], "Input"],

Cell[BoxData[
    StyleBox[\(Series\ de\ Taylor\),
      FontFamily->"Times New Roman",
      FontSize->18]], "Input"],

Cell[BoxData[
    \(Series[Cos[x], {x, 0, 10}]\)], "Input"],

Cell[BoxData[
    \(Normal[Series[Cos[x], {x, 0, 10}]]\)], "Input"],

Cell[BoxData[
    \(\(Table[
        scos[n, x_] = Normal[Series[Cos[x], {x, 0, n}]], {n, 0, 100, 
          2}];\)\)], "Input"],

Cell[BoxData[
    \(scos[10, x]\)], "Input"],

Cell[BoxData[
    \(graf[n_, a_, b_] := 
      Plot[{Cos[x], scos[n, x]}, {x, a, b}, PlotRange \[Rule] {\(-2\), 2}, 
        PlotStyle \[Rule] {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}]\)], "Input"],

Cell[BoxData[
    \(\(graf[10, \(-2\) Pi, 2  Pi];\)\)], "Input"],

Cell[BoxData[
    \(\(animacos[a_, b_] := Table[graf[n, a, b], {n, 0, 20, 2}];\)\)], "Input"],

Cell[BoxData[
    \(\(animacos[\(-4\) Pi, 4  Pi];\)\)], "Input"],

Cell[BoxData[
    \(animarcotangente[n_, a_, b_] := 
      Do[Plot[Evaluate[{ArcTan[x], 
              Normal[Series[ArcTan[x], {x, 0, k}]]}], {x, \(-a\), a}, 
          PlotRange \[Rule] {\(-b\), b}, 
          PlotStyle \[Rule] {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}], {k, 1, 
          n}]\)], "Input"],

Cell[BoxData[
    \(animarcotangente[10, 2, 3]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 354, 7, 57, "Input"],
Cell[2062, 59, 110, 3, 34, "Input"],
Cell[2175, 64, 139, 2, 30, "Input"],
Cell[2317, 68, 63, 1, 30, "Input"],
Cell[2383, 71, 75, 1, 30, "Input"],
Cell[2461, 74, 53, 1, 30, "Input"],
Cell[2517, 77, 54, 1, 30, "Input"],
Cell[2574, 80, 73, 1, 30, "Input"],
Cell[2650, 83, 56, 1, 30, "Input"],
Cell[2709, 86, 126, 3, 30, "Input"],
Cell[2838, 91, 110, 3, 34, "Input"],
Cell[2951, 96, 69, 1, 30, "Input"],
Cell[3023, 99, 476, 9, 90, "Input"],
Cell[3502, 110, 180, 3, 50, "Input"],
Cell[3685, 115, 224, 4, 50, "Input"],
Cell[3912, 121, 119, 2, 30, "Input"],
Cell[4034, 125, 72, 1, 30, "Input"],
Cell[4109, 128, 73, 1, 30, "Input"],
Cell[4185, 131, 118, 3, 34, "Input"],
Cell[4306, 136, 59, 1, 30, "Input"],
Cell[4368, 139, 67, 1, 30, "Input"],
Cell[4438, 142, 128, 3, 30, "Input"],
Cell[4569, 147, 44, 1, 30, "Input"],
Cell[4616, 150, 195, 3, 50, "Input"],
Cell[4814, 155, 64, 1, 30, "Input"],
Cell[4881, 158, 93, 1, 30, "Input"],
Cell[4977, 161, 64, 1, 30, "Input"],
Cell[5044, 164, 305, 6, 70, "Input"],
Cell[5352, 172, 59, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

